/*
 * Decompiled with CFR 0.152.
 */
package com.elfahja.enhancedRails;

import com.elfahja.enhancedRails.EnhancedRails;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.type.RedstoneRail;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class RailListener
implements Listener {
    private final HashMap<UUID, Location> minecartLocations = new HashMap();
    private final EnhancedRails plugin;

    public RailListener(EnhancedRails plugin) {
        this.plugin = plugin;
    }

    private void handleSuperSpeed(Minecart minecart) {
        if (!this.plugin.getConfig().getBoolean("super-speed.enabled", false)) {
            return;
        }
        double superMultiplier = this.plugin.getConfig().getDouble("super-speed-parameters.flat-speed-multiplier", 2.0);
        double slopeMultiplier = this.plugin.getConfig().getDouble("super-speed-parameters.slope-speed-multiplier", 1.1);
        double superMaxSpeed = this.plugin.getConfig().getDouble("super-speed-parameters.flat-max-speed", 4.0);
        double slopeMaxSpeed = this.plugin.getConfig().getDouble("super-speed-parameters.slope-max-speed", 2.0);
        if (minecart.getLocation().getBlock().getType().equals((Object)Material.POWERED_RAIL)) {
            RedstoneRail railData = (RedstoneRail)minecart.getLocation().getBlock().getBlockData();
            if (!railData.isPowered()) {
                return;
            }
            boolean hasSuperSpeed = false;
            boolean hasSlowDown = false;
            double slowDownSpeed = 0.0;
            List passengers = minecart.getPassengers();
            if (!passengers.isEmpty()) {
                for (Entity passenger : passengers) {
                    Material blockBelow;
                    if (!(passenger instanceof Player)) continue;
                    Player player = (Player)passenger;
                    if (this.plugin.getConfig().getBoolean("special-item.enabled", true)) {
                        ItemStack handItem = player.getInventory().getItemInMainHand();
                        String customName = "";
                        if (handItem.hasItemMeta() && handItem.getItemMeta().displayName() != null) {
                            customName = PlainTextComponentSerializer.plainText().serialize(Objects.requireNonNull(handItem.getItemMeta().displayName()));
                        }
                        String materialItemName = this.plugin.getConfig().getString("special-item.material", "TRIAL_KEY").toUpperCase();
                        String customItemName = this.plugin.getConfig().getString("special-item.custom-name", "Super Speed Key");
                        if (handItem.getType().name().equals(materialItemName) && (customName.isEmpty() || customItemName.equals(customName))) {
                            hasSuperSpeed = true;
                        }
                    } else if (this.plugin.getConfig().getBoolean("special-block.enabled", true) && (blockBelow = minecart.getLocation().getBlock().getRelative(0, -1, 0).getType()).name().equals(this.plugin.getConfig().getString("special-block.material", "SMOOTH_STONE").toUpperCase())) {
                        hasSuperSpeed = true;
                    }
                    if (!this.plugin.getConfig().getBoolean("slow-down-parameters.enabled", true)) break;
                    blockBelow = minecart.getLocation().getBlock().getRelative(0, -1, 0).getType();
                    if (blockBelow.name().equals(this.plugin.getConfig().getString("slow-down-parameters.block1-material", "GRAVEL").toUpperCase())) {
                        hasSlowDown = true;
                        slowDownSpeed = this.plugin.getConfig().getDouble("slow-down-parameters.block1-max-speed", 0.4);
                        break;
                    }
                    if (!blockBelow.name().equals(this.plugin.getConfig().getString("slow-down-parameters.block2-material", "SAND").toUpperCase())) break;
                    hasSlowDown = true;
                    slowDownSpeed = this.plugin.getConfig().getDouble("slow-down-parameters.block2-max-speed", 0.2);
                    break;
                }
                if (hasSlowDown) {
                    minecart.setMaxSpeed(slowDownSpeed);
                } else if (hasSuperSpeed) {
                    double targetMaxSpeed;
                    Vector currentVelocity = minecart.getVelocity();
                    Vector newVelocity = currentVelocity.multiply(superMultiplier);
                    Rail.Shape shape = railData.getShape();
                    boolean isSlope = this.isAscending(shape);
                    double d = targetMaxSpeed = isSlope ? slopeMaxSpeed : superMaxSpeed;
                    if (this.detectMinecartSlope(minecart) != 0) {
                        newVelocity = this.clampSlopeVelocity(minecart, currentVelocity.multiply(slopeMultiplier));
                    }
                    minecart.setVelocity(newVelocity);
                    minecart.setMaxSpeed(targetMaxSpeed);
                } else {
                    minecart.setMaxSpeed(0.4);
                }
            }
        }
    }

    private boolean isSameLocation(Location locationA, Location locationB) {
        return locationA.getWorld().equals((Object)locationB.getWorld()) && locationA.getBlockX() == locationB.getBlockX() && locationA.getBlockY() == locationB.getBlockY() && locationA.getBlockZ() == locationB.getBlockZ();
    }

    private boolean isAscending(Rail.Shape shape) {
        return shape == Rail.Shape.ASCENDING_EAST || shape == Rail.Shape.ASCENDING_WEST || shape == Rail.Shape.ASCENDING_NORTH || shape == Rail.Shape.ASCENDING_SOUTH;
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        if (event.getVehicle() instanceof Minecart) {
            Minecart minecart = (Minecart)event.getVehicle();
            Location currentLoc = minecart.getLocation();
            UUID minecartId = minecart.getUniqueId();
            if (this.minecartLocations.containsKey(minecartId) && this.isSameLocation(this.minecartLocations.get(minecartId), currentLoc)) {
                return;
            }
            this.minecartLocations.put(minecartId, currentLoc);
            this.handleSuperSpeed(minecart);
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart) {
            Minecart minecart = (Minecart)vehicle;
            this.minecartLocations.remove(minecart.getUniqueId());
        }
    }

    private void debugMsg(String msg) {
        ((EnhancedRails)EnhancedRails.getPlugin(EnhancedRails.class)).getLogger().info(msg);
    }

    public int detectMinecartSlope(Minecart minecart) {
        Block block = minecart.getLocation().getBlock();
        if (block.getType() == Material.POWERED_RAIL || block.getType() == Material.DETECTOR_RAIL || block.getType() == Material.ACTIVATOR_RAIL || block.getType() == Material.RAIL) {
            Rail rail = (Rail)block.getBlockData();
            Rail.Shape shape = rail.getShape();
            if (shape == Rail.Shape.ASCENDING_EAST || shape == Rail.Shape.ASCENDING_WEST || shape == Rail.Shape.ASCENDING_NORTH || shape == Rail.Shape.ASCENDING_SOUTH) {
                boolean goingSouth;
                Vector velocity = minecart.getVelocity();
                boolean goingEast = velocity.getX() > 0.0;
                boolean goingWest = velocity.getX() < 0.0;
                boolean goingNorth = velocity.getZ() < 0.0;
                boolean bl = goingSouth = velocity.getZ() > 0.0;
                if (shape == Rail.Shape.ASCENDING_EAST && goingEast || shape == Rail.Shape.ASCENDING_WEST && goingWest || shape == Rail.Shape.ASCENDING_NORTH && goingNorth || shape == Rail.Shape.ASCENDING_SOUTH && goingSouth) {
                    return 1;
                }
                if (shape == Rail.Shape.ASCENDING_EAST && goingWest || shape == Rail.Shape.ASCENDING_WEST && goingEast || shape == Rail.Shape.ASCENDING_NORTH && goingSouth || shape == Rail.Shape.ASCENDING_SOUTH && goingNorth) {
                    return -1;
                }
            }
            return 0;
        }
        return 0;
    }

    public Vector clampSlopeVelocity(Minecart minecart, Vector newVelocity) {
        double maxSlopeSpeed;
        Vector velocity = newVelocity;
        double xVel = velocity.getX();
        double zVel = velocity.getZ();
        int slope = this.detectMinecartSlope(minecart);
        double horizontalSpeed = Math.sqrt(xVel * xVel + zVel * zVel);
        if (slope == 1) {
            maxSlopeSpeed = this.plugin.getConfig().getDouble("super-speed-parameters.max-uphill-velocity", 0.8);
        } else if (slope == -1) {
            maxSlopeSpeed = this.plugin.getConfig().getDouble("super-speed-parameters.max-downhill-velocity", 2.0);
        } else {
            return velocity;
        }
        if (horizontalSpeed > maxSlopeSpeed) {
            double factor = maxSlopeSpeed / horizontalSpeed;
            velocity = new Vector(xVel *= factor, 0.0, zVel *= factor);
        }
        return velocity;
    }
}

